<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Update records based on sumber field for OPD records
        $opdSumberMapping = [
            'Badan Pengelola Keuangan dan Aset Daerah Provinsi Jawa Tengah' => 2, // BPKAD user_id
            'Dinas Pendidikan dan Kebudayaan Provinsi Jawa Tengah' => 3, // Disdikbud user_id
        ];
        
        foreach ($opdSumberMapping as $sumberPattern => $userId) {
            DB::table('inventarisasi_hukum')
                ->where('sumber', 'like', '%' . $sumberPattern . '%')
                ->where(function($query) use ($userId) {
                    $query->whereNull('created_by_user_id')
                          ->orWhere('created_by_user_id', '!=', $userId);
                })
                ->update([
                    'created_by_role' => 'opd',
                    'created_by_user_id' => $userId,
                    'updated_at' => now()
                ]);
        }
        
        // Also check exact matches for sumber field
        foreach ($opdSumberMapping as $sumberPattern => $userId) {
            DB::table('inventarisasi_hukum')
                ->where('sumber', $sumberPattern)
                ->where(function($query) use ($userId) {
                    $query->whereNull('created_by_user_id')
                          ->orWhere('created_by_user_id', '!=', $userId);
                })
                ->update([
                    'created_by_role' => 'opd',
                    'created_by_user_id' => $userId,
                    'updated_at' => now()
                ]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        // This migration is additive, no need to reverse
        // The previous migration handles the rollback
    }
};
